% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_add_divider.R
\name{gt_add_divider}
\alias{gt_add_divider}
\title{Add a dividing border to an existing \code{gt} table.}
\usage{
gt_add_divider(
  gt_object,
  columns,
  sides = "right",
  color = "grey",
  style = "solid",
  weight = px(2),
  include_labels = TRUE
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{columns}{Specific columns to apply color to, accepts either \code{tidyeval} colum names or columns by position.}

\item{sides}{The border sides to be modified. Options include \code{"left"}, \code{"right"}, \code{"top"}, and \code{"bottom"}. For all borders surrounding the selected cells, we can use the `"all"`` option.}

\item{color, style, weight}{The border color, style, and weight. The \code{color} can be defined with a color name or with a hexadecimal color code. The default \code{color} value is \code{"#00FFFFFF"} (black). The \code{style} can be one of either \code{"solid"} (the default), \code{"dashed"}, or \code{"dotted"}. The \code{weight} of the border lines is to be given in pixel values (the \code{px()} helper function is useful for this. The default value for \code{weight} is \code{"1px"}.}

\item{include_labels}{A logical, either \code{TRUE} or \code{FALSE} indicating whether to also add dividers through the column labels.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt_add_divider} function takes an existing \code{gt_tbl} object and
adds borders or dividers to specific columns.
}
\section{Figures}{

\if{html}{\figure{add-divider.png}{options: width=70\%}}
}

\section{Function ID}{

2-11
}

\examples{
library(gt)
basic_divider <- head(mtcars) \%>\%
  gt() \%>\%
  gt_add_divider(columns = "cyl", style = "dashed")


}
\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_fa_repeats}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
