% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_and_stack.R
\name{gt_merge_stack}
\alias{gt_merge_stack}
\title{Merge and stack text from two columns in \code{gt}}
\usage{
gt_merge_stack(
  gt_object,
  col1,
  col2,
  palette = c("black", "grey"),
  ...,
  small_cap = TRUE,
  font_size = c("14px", "10px"),
  font_weight = c("bold", "bold")
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{col1}{The column to stack on top. Will be converted to all caps, with black and bold text.}

\item{col2}{The column to merge and place below. Will be smaller and dark grey.}

\item{palette}{The colors for the text, where the first color is the top ,
ie \code{col1} and the second color is the bottom, ie \code{col2}. Defaults to \code{c("black","grey")}.
For more information on built-in color names, see \code{\link[=colors]{colors()}}.}

\item{...}{
  Arguments passed on to \code{\link[scales:col2hcl]{scales::col2hcl}}
  \describe{
    \item{\code{h}}{Hue, \verb{[0, 360]}}
    \item{\code{c}}{Chroma, \verb{[0, 100]}}
    \item{\code{l}}{Luminance, \verb{[0, 100]}}
    \item{\code{alpha}}{Alpha, \verb{[0, 1]}.}
  }}

\item{small_cap}{a logical indicating whether to use 'small-cap' on the top line of text}

\item{font_size}{a string of length 2 indicating the font-size in px of the top and bottom text}

\item{font_weight}{a string of length 2 indicating the 'font-weight' of the top and bottom text. Must be one of 'bold', 'normal', 'lighter'}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt_merge_stack()} function takes an existing \code{gt} table and merges
column 1 and column 2, stacking column 1's text on top of column 2's.
Top text is in all caps with black bold text, while the lower text is smaller
and dark grey.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(gt)
teams <- "https://github.com/nflverse/nflfastR-data/raw/master/teams_colors_logos.rds"
team_df <- readRDS(url(teams))

stacked_tab <- team_df \%>\%
 dplyr::select(team_nick, team_abbr, team_conf, team_division, team_wordmark) \%>\%
 head(8) \%>\%
 gt(groupname_col = "team_conf") \%>\%
 gt_merge_stack(col1 = team_nick, col2 = team_division) \%>\%
 gt_img_rows(team_wordmark)
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{merge-stack.png}{options: width=50\%}}
}

\section{Function ID}{

2-6
}

\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_fa_repeats}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_border}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_multi_rows}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack_color}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{img_header}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
