% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bold_p.R
\name{bold_p.tbl_summary}
\alias{bold_p.tbl_summary}
\title{Bold significant p-values or q-values}
\usage{
\method{bold_p}{tbl_summary}(x, t = 0.05, q = FALSE, ...)
}
\arguments{
\item{x}{Object created using \code{tbl_summary} function}

\item{t}{Threshold below which values will be bold. Default is 0.05.}

\item{q}{Logical argument. When TRUE will bold the q-value column rather
than the p-values. Default is \code{FALSE}.}

\item{...}{Not used}
}
\value{
A \code{tbl_summary} object
}
\description{
Bold values below a chosen threshold (e.g. <0.05)
in \link{tbl_summary} tables.
}
\section{Example Output}{

\if{html}{\figure{tbl_sum_bold_p_ex.png}{options: width=50\%}}
}

\examples{
tbl_sum_bold_p_ex <-
  trial[c("age", "grade", "response", "trt")] \%>\%
  tbl_summary(by = trt) \%>\%
  add_p() \%>\%
  bold_p()
}
\seealso{
Other tbl_summary tools: 
\code{\link{add_n}()},
\code{\link{add_overall}()},
\code{\link{add_p}()},
\code{\link{add_q.tbl_summary}()},
\code{\link{add_stat_label}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_summary}()},
\code{\link{modify_header}()},
\code{\link{sort_p.tbl_summary}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_summary}()}
}
\author{
Daniel D. Sjoberg, Esther Drill
}
\concept{tbl_summary tools}
