% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_tidiers.R
\name{custom_tidiers}
\alias{custom_tidiers}
\alias{tidy_standardize}
\alias{tidy_bootstrap}
\alias{pool_and_tidy_mice}
\title{Collection of custom tidiers}
\usage{
tidy_standardize(
  x,
  exponentiate = FALSE,
  conf.level = 0.95,
  conf.int = TRUE,
  ...,
  quiet = FALSE
)

tidy_bootstrap(
  x,
  exponentiate = FALSE,
  conf.level = 0.95,
  conf.int = TRUE,
  ...,
  quiet = FALSE
)

pool_and_tidy_mice(x, pool.args = NULL, ..., quiet = FALSE)
}
\arguments{
\item{x}{a regression model object}

\item{exponentiate}{Logical indicating whether or not to exponentiate the
the coefficient estimates. This is typical for logistic and multinomial
regressions, but a bad idea if there is no log or logit link. Defaults
to \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval
if \code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}

\item{...}{arguments passed to method;
\itemize{
\item \code{pool_and_tidy_mice()}: \code{mice::tidy(x, ...)}
\item \code{tidy_standardize()}: \code{effectsize::standardize_parameters(x, ...)}
\item \code{tidy_bootstrap()}: \code{parameters::bootstrap_parameters(x, ...)}
}}

\item{quiet}{Logical indicating whether to print messages in console. Default is
\code{FALSE}}

\item{pool.args}{named list of arguments passed to \code{mice::pool()} in
\code{pool_and_tidy_mice()}. Default is \code{NULL}}
}
\description{
\lifecycle{experimental}
Collection of tidiers that can be passed to \code{tbl_regression()}
and \code{tbl_uvregression()} to obtain modified results. See examples below.
}
\section{Details}{

\itemize{
\item \code{tidy_standardize()} tidier to report standardized coefficients. The
\href{https://easystats.github.io/effectsize/reference/standardize_parameters.html}{effectsize}
package includes a wonderful function to estimate standardized coefficients.
The tidier uses the output from \code{effectsize::standardize_parameters()}, and
merely takes the result and puts it in \code{broom::tidy()} format.
\item \code{tidy_bootstrap()} tidier to report bootstrapped coefficients. The
\href{https://easystats.github.io/parameters/reference/model_parameters.default.html}{parameters}
package includes a wonderful function to estimate bootstrapped coefficients.
The tidier uses the output from \code{parameters::bootstrap_parameters(test = "p")}, and
merely takes the result and puts it in \code{broom::tidy()} format.
\item \code{pool_and_tidy_mice()} tidier to report models resulting from multiply imputed data
using the mice package. Pass the mice model object \emph{before} the model results
have been pooled. See example.
}

Ensure your model type is compatible with the methods/functions used to estimate
the model parameters before attempting to use the tidier with \code{tbl_regression()}
}

\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{tidy_standardize_ex1.png}{options: width=65\%}}

\if{html}{Example 2}

\if{html}{\figure{tidy_standardize_ex2.png}{options: width=47\%}}

\if{html}{Example 3}

\if{html}{\figure{pool_and_tidy_mice_ex3.png}{options: width=47\%}}
}

\examples{
# Example 1 ----------------------------------
mod <- lm(age ~ marker + grade, trial)

tbl_stnd <- tbl_regression(mod, tidy_fun = tidy_standardize)
tbl <- tbl_regression(mod)

tidy_standardize_ex1 <-
  tbl_merge(
    list(tbl_stnd, tbl),
    tab_spanner = c("**Standardized Model**", "**Original Model**")
  )

# Example 2 ----------------------------------
# use "posthoc" method for coef calculation
tidy_standardize_ex2 <-
  tbl_regression(mod, tidy_fun = purrr::partial(tidy_standardize, method = "posthoc"))


# Example 3 ----------------------------------
# Multiple Imputation using the mice package
pool_and_tidy_mice_ex3 <-
  suppressWarnings(mice::mice(trial, m = 2)) \%>\%
  with(lm(age ~ marker + grade)) \%>\%
  tbl_regression() # mice method called that uses `pool_and_tidy_mice()` as tidier

}
