% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inline_text.R
\name{inline_text.tbl_survfit}
\alias{inline_text.tbl_survfit}
\title{Report statistics from survfit tables inline}
\usage{
\method{inline_text}{tbl_survfit}(
  x,
  variable = NULL,
  level = NULL,
  pattern = NULL,
  time = NULL,
  prob = NULL,
  column = NULL,
  estimate_fun = x$inputs$estimate_fun,
  pvalue_fun = NULL,
  ...
)
}
\arguments{
\item{x}{Object created from  \link{tbl_survfit}}

\item{variable}{Variable name of statistic to present.}

\item{level}{Level of the variable to display for categorical variables.
Can also specify the 'Unknown' row.  Default is \code{NULL}}

\item{pattern}{String indicating the statistics to return.}

\item{time}{time for which to return survival probabilities.}

\item{prob}{probability with values in (0,1)}

\item{column}{column to print from \code{x$table_body}.
Columns may be selected with \verb{time=} or \verb{prob=} as well.}

\item{estimate_fun}{Function to round and format estimate and confidence limits.
Default is the same function used in \code{tbl_survfit()}}

\item{pvalue_fun}{Function to round and format p-values.
Default is \link{style_pvalue}.
The function must have a numeric vector input (the numeric, exact p-value),
and return a string that is the rounded/formatted p-value (e.g.
\code{pvalue_fun = function(x) style_pvalue(x, digits = 2)} or equivalently,
\code{purrr::partial(style_pvalue, digits = 2)}).}

\item{...}{Not used}
}
\value{
A string reporting results from a gtsummary table
}
\description{
\lifecycle{maturing}
Extracts and returns statistics from a \code{tbl_survfit} object for
inline reporting in an R markdown document. Detailed examples in the
\href{https://www.danieldsjoberg.com/gtsummary/articles/inline_text.html}{inline_text vignette}
}
\examples{
\dontshow{if (broom.helpers::.assert_package("survival", pkg_search = "gtsummary", boolean = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(survival)
# fit survfit
fit1 <- survfit(Surv(ttdeath, death) ~ trt, trial)
fit2 <- survfit(Surv(ttdeath, death) ~ 1, trial)

# sumarize survfit objects
tbl1 <-
  tbl_survfit(
    fit1,
    times = c(12, 24),
    label = "Treatment",
    label_header = "**{time} Month**"
  ) \%>\%
  add_p()

tbl2 <-
  tbl_survfit(
    fit2,
    probs = 0.5,
    label_header = "**Median Survival**"
  )

# report results inline
inline_text(tbl1, time = 24, level = "Drug B")
inline_text(tbl1, column = p.value)
inline_text(tbl2, prob = 0.5)
\dontshow{\}) # examplesIf}
}
\seealso{
Other tbl_summary tools: 
\code{\link{add_ci}()},
\code{\link{add_n.tbl_summary}()},
\code{\link{add_overall}()},
\code{\link{add_p.tbl_summary}()},
\code{\link{add_q}()},
\code{\link{add_stat_label}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_summary}()},
\code{\link{modify}},
\code{\link{separate_p_footnotes}()},
\code{\link{tbl_custom_summary}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_split}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_strata}()},
\code{\link{tbl_summary}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_summary tools}
