% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_hux_table.R
\name{as_hux_table}
\alias{as_hux_table}
\alias{as_hux_xlsx}
\title{Convert gtsummary object to a huxtable object}
\usage{
as_hux_table(
  x,
  include = everything(),
  return_calls = FALSE,
  strip_md_bold = FALSE
)

as_hux_xlsx(x, file, include = everything(), bold_header_rows = TRUE)
}
\arguments{
\item{x}{Object created by a function from the gtsummary package
(e.g. \link{tbl_summary} or \link{tbl_regression})}

\item{include}{Commands to include in output. Input may be a vector of
quoted or unquoted names. tidyselect and gtsummary select helper
functions are also accepted.
Default is \code{everything()}.}

\item{return_calls}{Logical. Default is \code{FALSE}. If \code{TRUE}, the calls are returned
as a list of expressions.}

\item{strip_md_bold}{DEPRECATED}

\item{file}{File path for the output.}

\item{bold_header_rows}{logical indicating whether to bold header rows.
Default is \code{TRUE}}
}
\value{
A {huxtable} object
}
\description{
Function converts a gtsummary object to a huxtable object.
A user can use this function if they wish to add customized formatting
available via the huxtable functions. The huxtable package supports output
to PDF via LaTeX, as well as HTML and Word.
}
\section{Excel Output}{


Use the \code{as_hux_xlsx()} function to save a copy of the table in an excel file.
The file is saved using \code{huxtable::quick_xlsx()}.
}

\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true") && broom.helpers::.assert_package("huxtable", pkg_search = "gtsummary", boolean = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
trial \%>\%
  dplyr::select(trt, age, grade) \%>\%
  tbl_summary(by = trt) \%>\%
  add_p() \%>\%
  as_hux_table()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other gtsummary output types: 
\code{\link{as_flex_table}()},
\code{\link{as_gt}()},
\code{\link{as_kable_extra}()},
\code{\link{as_kable}()},
\code{\link{as_tibble.gtsummary}()}
}
\author{
David Hugh-Jones, Daniel D. Sjoberg
}
\concept{gtsummary output types}
