% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brdg_wide_summary.R
\name{brdg_wide_summary}
\alias{brdg_wide_summary}
\title{Wide summary table bridge}
\usage{
brdg_wide_summary(cards, variables, statistic, type)
}
\arguments{
\item{cards}{(\code{card})\cr
An ARD object of class \code{"card"} typically created with \verb{cards::ard_*()} functions.}

\item{variables}{(\code{character})\cr
character list of variables}

\item{statistic}{(named \code{list})\cr
named list of summary statistic names}

\item{type}{(named \code{list})\cr
named list of summary types}
}
\value{
a gtsummary object
}
\description{
Bridge function for converting \code{tbl_wide_summary()} (and similar) cards to basic gtsummary objects.
All bridge functions begin with prefix \verb{brdg_*()}.
}
\examples{
library(cards)

bind_ard(
  ard_continuous(trial, variables = c(age, marker)),
  ard_attributes(trial, variables = c(age, marker))
) |>
  brdg_wide_summary(
    variables = c("age", "marker"),
    statistic = list(age = c("{mean}", "{sd}"), marker = c("{mean}", "{sd}")),
    type = list(age = "continuous", marker = "continuous")
  )
}
