% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_ci.tbl_svysummary.R
\name{add_ci.tbl_svysummary}
\alias{add_ci.tbl_svysummary}
\title{Add CI Column}
\usage{
\method{add_ci}{tbl_svysummary}(
  x,
  method = list(all_continuous() ~ "svymean", all_categorical() ~ "svyprop.logit"),
  include = everything(),
  statistic = list(all_continuous() ~ "{conf.low}, {conf.high}", all_categorical() ~
    "{conf.low}\%, {conf.high}\%"),
  conf.level = 0.95,
  style_fun = list(all_continuous() ~ label_style_sigfig(), all_categorical() ~
    label_style_sigfig(scale = 100)),
  pattern = NULL,
  df = survey::degf(x$inputs$data),
  ...
)
}
\arguments{
\item{x}{(\code{tbl_summary})\cr
a summary table of class \code{'tblsummary'}}

\item{method}{(\code{\link[=syntax]{formula-list-selector}})\cr
Confidence interval method. Default is
\code{list(all_continuous() ~ "svymean", all_categorical() ~ "svyprop.logit")}.
See details below.}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in the summary table. Default is \code{everything()}.}

\item{statistic}{(\code{\link[=syntax]{formula-list-selector}})\cr
Indicates how the confidence interval will be displayed.
Default is \code{list(all_continuous() ~ "{conf.low}, {conf.high}", all_categorical() ~ "{conf.low}\%, {conf.high}\%")}}

\item{conf.level}{(scalar \code{real})\cr
Confidence level. Default is \code{0.95}}

\item{style_fun}{(\code{function})\cr
Function to style upper and lower bound of confidence interval. Default is
\code{list(all_continuous() ~ label_style_sigfig(), all_categorical() ~ label_style_sigfig(scale =  100))}.}

\item{pattern}{(\code{string})\cr
Indicates the pattern to use to merge the CI with
the statistics cell. The default is NULL, where no columns are merged.
The two columns that will be merged are the statistics column,
represented by \code{"{stat}"} and the CI column represented by \code{"{ci}"},
e.g. \code{pattern = "{stat} ({ci})"} will merge the two columns with the CI
in parentheses. Default is \code{NULL}, and no merging is performed.}

\item{df}{(\code{numeric})\cr
denominator degrees of freedom, passed to \code{survey::svyciprop(df)} or \code{confint(df)}.
Default is \code{survey::degf(x$inputs$data)}.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
gtsummary table
}
\description{
Add a new column with the confidence intervals for proportions, means, etc.
}
\section{method argument}{


Must be one of
\itemize{
\item \code{"svyprop.logit"}, \code{"svyprop.likelihood"}, \code{"svyprop.asin"},
\code{"svyprop.beta"}, \code{"svyprop.mean"}, \code{"svyprop.xlogit"}
calculated via \code{survey::svyciprop()} for \strong{categorical} variables
\item \code{"svymean"} calculated via \code{survey::svymean()} for \strong{continuous} variables
\item \code{"svymedian.mean"}, \code{"svymedian.beta"}, \code{"svymedian.xlogit"},
\code{"svymedian.asin"}, \code{"svymedian.score"} calculated via \code{survey::svyquantile(quantiles = 0.5)} for \strong{continuous} variables
}
}

\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed("survey") && gtsummary:::is_pkg_installed("broom",  ref = "cardx")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(api, package = "survey")
survey::svydesign(id = ~dnum, weights = ~pw, data = apiclus1, fpc = ~fpc) |>
  tbl_svysummary(
    by = "both",
    include = c(api00, stype),
    statistic = all_continuous() ~ "{mean} ({sd})"
  ) |>
  add_stat_label() |>
  add_ci(pattern = "{stat} (95\% CI {ci})") |>
  modify_header(all_stat_cols() ~ "**{level}**") |>
  modify_spanning_header(all_stat_cols() ~ "**Survived**")
\dontshow{\}) # examplesIf}
}
