% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-studies.R
\name{countries_tbl}
\alias{countries_tbl}
\title{Creates a countries table.}
\usage{
countries_tbl(
  study_id = character(),
  ancestry_id = integer(),
  country_name = character(),
  major_area = character(),
  region = character()
)
}
\arguments{
\item{study_id}{GWAS Catalog study accession identifier.}

\item{ancestry_id}{Ancestry identifier.}

\item{country_name}{Country name, according to
\href{https://unstats.un.org/unsd/methodology/m49/overview/}{The United
Nations M49 Standard of Geographic Regions.}}

\item{major_area}{Region name, according to
\href{https://unstats.un.org/unsd/methodology/m49/overview/}{The United
Nations M49 Standard of Geographic Regions.}}

\item{region}{Sub-region name, according to
\href{https://unstats.un.org/unsd/methodology/m49/overview/}{The United
Nations M49 Standard of Geographic Regions.}}
}
\value{
A \code{\link[tibble]{tibble}} whose columns are the named arguments
  to the function.
}
\description{
Creates a countries table. This
function is used internally to create both the \code{countries_of_origin} and
\code{countries_of_recruitment} slots of a \linkS4class{studies} object.
}
\keyword{internal}
