% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_studies.R
\name{get_studies_by_reported_trait}
\alias{get_studies_by_reported_trait}
\title{Get GWAS Catalog studies by reported traits}
\usage{
get_studies_by_reported_trait(
  reported_trait = NULL,
  verbose = FALSE,
  warnings = TRUE,
  page_size = 20L
)
}
\arguments{
\item{reported_trait}{A character vector of phenotypic traits as
reported by the original authors' the study.}

\item{verbose}{Whether the function should be
verbose about the different queries or not.}

\item{warnings}{Whether to print warnings.}

\item{page_size}{An integer scalar indicating the
\href{https://www.ebi.ac.uk/gwas/rest/docs/api#_paging_resources}{page}
value to be used in the JSON requests, can be between \code{1} and
\code{1000}.}
}
\value{
A \linkS4class{studies} object.
}
\description{
Gets studies that match the reported traits, as reported by the original
authors' of the study.
}
\keyword{internal}
