% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.haplotype_frequency}
\alias{plot.haplotype_frequency}
\title{Line plot of haplotype_frequency object}
\usage{
\method{plot}{haplotype_frequency}(
  x,
  y = NA,
  plot_type = c("haplotype_structure_frequency", "result_snps"),
  type = c("version1", "version2"),
  ly = TRUE,
  nwin,
  title,
  line_size = 0.6,
  ...
)
}
\arguments{
\item{x}{an object of class haplotype_frequency}

\item{y}{default value is `NA`, if specified it should be a vector of names of
subject groups i.e. `y = c("case","control")`}

\item{plot_type}{either \dQuote{result_snps} or \dQuote{"haplotype_structure_frequency"}}

\item{type}{either \dQuote{version1} or \dQuote{version2} when plot_type is \dQuote{"haplotype_structure_frequency"}}

\item{ly}{if TRUE, we have a plotly object and if it is false plot is going to be
a ggplot object.}

\item{nwin}{window number}

\item{title}{title of the plot.}

\item{line_size}{geom_line size}

\item{...}{optional argument of \code{plot}}
}
\value{
an interactive line plot of haplotype_frequency objects for each case control subjects.
}
\description{
Line plot of haplotype_frequency object
}
\examples{
\donttest{
piggyback::pb_download(repo = "soroushmdg/gwid",tag = "v0.0.1",dest = tempdir())
ibd_data_file <- paste0(tempdir(),"//chr3.ibd")
genome_data_file <- paste0(tempdir(),"//chr3.gds")
phase_data_file <- paste0(tempdir(),"//chr3.vcf")
case_control_data_file <- paste0(tempdir(),"//case-cont-RA.withmap.Rda")
# case-control data
case_control <- gwid::case_control(case_control_rda = case_control_data_file)
names(case_control) #cases and controls group
summary(case_control) # in here, we only consider cases,cont1,cont2,cont3 groups in the study
case_control$cases[1:3] # first three subject names of cases group
# read SNP data (use SNPRelate to convert it to gds) and count number of minor alleles
snp_data_gds <- gwid::build_gwas(gds_data = genome_data_file,
caco = case_control,gwas_generator = TRUE)
class(snp_data_gds)
names(snp_data_gds)
head(snp_data_gds$snps) # it has information about counts of minor alleles in each location.
# read haplotype data (output of beagle)
haplotype_data <- gwid::build_phase(phased_vcf = phase_data_file,caco = case_control)
class(haplotype_data)
names(haplotype_data)
dim(haplotype_data$Hap.1) #22302 SNP and 1911 subjects
# read IBD data (output of Refined-IBD)
ibd_data <- gwid::build_gwid(ibd_data = ibd_data_file,gwas = snp_data_gds)
class(ibd_data)
ibd_data$ibd # refined IBD output
ibd_data$res # count number of IBD for each SNP location
# plot count of IBD in chromosome 3
plot(ibd_data,y = c("cases","cont1"),ly = FALSE)
# Further investigate location between 117M and 122M
# significant number of IBD's in group cases, compare to cont1, cont2 and cont3.
plot(ibd_data,y = c("cases","cont1"),snp_start = 119026294,snp_end = 120613594,ly = FALSE)
model_fisher <- gwid::fisher_test(ibd_data,case_control,reference = "cases",
snp_start = 119026294,snp_end = 120613594)
class(model_fisher)
plot(model_fisher, y = c("cases","cont1"),ly = FALSE)
hap_str <- gwid::haplotype_structure(ibd_data,phase = haplotype_data,w = 10,
snp_start = 119026294,snp_end = 120613594)
haplo_freq <- gwid::haplotype_frequency(hap_str)
plot(haplo_freq,y = c("cases", "cont1"),plot_type = "haplotype_structure_frequency",
nwin = 1, type = "version1",ly = FALSE)
}
}
