% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tiling.R
\encoding{UTF-8}
\name{tiling}
\alias{tiling}
\title{Hyperbolic tiling}
\usage{
tiling(n, p, depth = 4, colors = c("navy", "yellow"), circle = TRUE, ...)
}
\arguments{
\item{n, p}{two positive integers satisfying \code{1/n + 1/p < 1/2}}

\item{depth}{positive integer, the number of recursions}

\item{colors}{two colors to fill the hyperbolic tiling}

\item{circle}{Boolean, whether to draw the unit circle}

\item{...}{additional arguments passed to \code{\link[plotrix]{draw.circle}}}
}
\value{
No returned value, just draws the hyperbolic tiling.
}
\description{
Draw a hyperbolic tiling of the Poincaré disk.
}
\note{
The higher value of \code{n}, the slower. And of course
  increasing \code{depth} slows down the rendering. The value of \code{p}
  has no influence on the speed.
}
\examples{
library(gyro)
tiling(3, 7, border = "orange")
}
