% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\encoding{UTF-8}
\name{plotGyroMesh}
\alias{plotGyroMesh}
\title{Plot hyperbolic mesh}
\usage{
plotGyroMesh(
  mesh,
  s = 1,
  model = "U",
  iterations = 5,
  n = 100,
  edges = TRUE,
  edgesAsTubes = TRUE,
  edgesColor = "yellow",
  tubesRadius = 0.03,
  verticesAsSpheres = edgesAsTubes,
  spheresColor = edgesColor,
  spheresRadius = 0.05,
  facesColor = "navy",
  bias = 1,
  interpolate = "linear",
  g = identity
)
}
\arguments{
\item{mesh}{there are two possibilities for this argument; it can be a
triangle \strong{rgl} mesh (class \code{mesh3d}) or a list with (at least)
two fields: \code{vertices}, a numeric matrix with three columns, and
\code{faces}, an integer matrix with three columns}

\item{s}{positive number, the radius of the Poincaré ball if
\code{model="M"}, otherwise, if \code{model="U"}, this number
defines the hyperbolic curvature (the smaller, the more curved)}

\item{model}{the hyperbolic model, either \code{"M"} (Möbius model, i.e.
Poincaré model) or \code{"U"} (Ungar model, i.e. hyperboloid model)}

\item{iterations}{argument passed to \code{\link{gyrotriangle}}}

\item{n}{argument passed to \code{\link{gyrotube}} or
\code{\link{gyrosegment}}, the number of points for each edge}

\item{edges}{Boolean, whether to plot the edges (as tubes or as lines)}

\item{edgesAsTubes}{Boolean, whether to plot tubular edges; if \code{FALSE},
the edges are plotted as lines}

\item{edgesColor}{a color for the edges}

\item{tubesRadius}{radius of the tubes, if \code{edgesAsTubes = TRUE}}

\item{verticesAsSpheres}{Boolean, whether to plot the vertices as
spheres; if \code{FALSE}, the vertices are not plotted}

\item{spheresColor}{a color for the spheres, if
\code{verticesAsSpheres = TRUE}}

\item{spheresRadius}{radius of the spheres,
if \code{verticesAsSpheres = TRUE}}

\item{facesColor}{this argument sets the color of the faces; it can be
either a single color or a color palette, i.e. a vector of colors; if it
is a color palette, it will be passed to the argument \code{palette} of
\code{\link{gyrotriangle}}}

\item{bias, interpolate, g}{these arguments are passed to
\code{\link{gyrotriangle}} in the case when \code{facesColor} is a color
palette}
}
\value{
No value, called for plotting.
}
\description{
Plot the hyperbolic version of a triangle 3D mesh.
}
\examples{
# hyperbolic great stellated dodecahedron
library(gyro)
library(rgl)
GSD <- system.file(
  "extdata", "greatStellatedDodecahedron.ply", package = "gyro"
)
mesh <- Rvcg::vcgPlyRead(GSD, updateNormals = FALSE, clean = FALSE)
\donttest{open3d(windowRect = c(50, 50, 562, 562), zoom = 0.7)
plotGyroMesh(
  mesh,
  edgesAsTubes = FALSE, edgesColor = "black",
  facesColor = "firebrick1"
)}
}
