% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.klime}
\alias{h2o.klime}
\title{Fits a k-LIME model on predictions produced by a ML model. Provides explanations/reason codes.}
\usage{
h2o.klime(training_frame, x, y, model_id = NULL, max_k = 20,
  estimate_k = TRUE, alpha = 0.5, min_cluster_size = 20, seed = -1)
}
\arguments{
\item{training_frame}{Id of the training data frame (Not required, to allow initial validation of model parameters).}

\item{x}{A vector containing the names or indices of the predictor variables to use in building the model.
If x is missing,then all columns except y are used.}

\item{y}{The name of the response variable in the model.If the data does not contain a header, this is the first column
index, and increasing from left to right. (The response must be either an integer or a
categorical variable).}

\item{model_id}{Destination id for this model; auto-generated if not specified.}

\item{max_k}{Maximum number of clusters to be considered. Defaults to 20.}

\item{estimate_k}{\code{Logical}. Automatically determine the number of clusters in an unsupervised manner. Defaults to TRUE.}

\item{alpha}{Balance between L1 and L2 regularization. Use alpha=0 to switch off L1 variable selection. Defaults to 0.5.}

\item{min_cluster_size}{Required minimum cluster size to build a local regression model, smaller clusters will use a global model.
Defaults to 20.}

\item{seed}{Seed for random numbers (affects certain parts of the algo that are stochastic and those might or might not be enabled by default)
Defaults to -1 (time-based random number).}
}
\description{
Fits a k-LIME model on predictions produced by a ML model. Provides explanations/reason codes.
}

