% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.std_coef_plot}
\alias{h2o.std_coef_plot}
\title{Plot Standardized Coefficient Magnitudes}
\usage{
h2o.std_coef_plot(model, num_of_features = NULL)
}
\arguments{
\item{model}{A trained generalized linear model}

\item{num_of_features}{The number of features to be shown in the plot}
}
\description{
Plot a GLM model's standardized coefficient magnitudes.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.importFile(prostate_path)
prostate[,2] <- as.factor(prostate[,2])
prostate_glm <- h2o.glm(y = "CAPSULE", x = c("AGE","RACE","PSA","DCAPS"),
                         training_frame = prostate, family = "binomial",
                         nfolds = 0, alpha = 0.5, lambda_search = FALSE)
h2o.std_coef_plot(prostate_glm)
}
}
\seealso{
\code{\link{h2o.varimp_plot}} for variable importances plot of
         random forest, GBM, deep learning.
}
