% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{as.factor}
\alias{as.factor}
\title{Convert H2O Data to Factors}
\usage{
as.factor(x)
}
\arguments{
\item{x}{a column from an H2OFrame data set.}
}
\description{
Convert column/columns in the current frame to categoricals.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

# Single column
cars <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv"
df <- h2o.importFile(cars)
df["cylinders"] <- as.factor(df["cylinders"])
h2o.describe(df["cylinders"])

# Multiple columns
cars <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv"
df <- h2o.importFile(cars)
df[c("cylinders","economy_20mpg")] <- as.factor(df[c("cylinders","economy_20mpg")])
h2o.describe(df[c("cylinders","economy_20mpg")])
}
}
\seealso{
\code{\link{as.factor}}.
}
