% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.coef_with_p_values}
\alias{h2o.coef_with_p_values}
\title{Return the coefficients table with coefficients, standardized coefficients, p-values, z-values and std-error for GLM models}
\usage{
h2o.coef_with_p_values(object)
}
\arguments{
\item{object}{An \linkS4class{H2OModel} object.}
}
\description{
Return the coefficients table with coefficients, standardized coefficients, p-values, z-values and std-error for GLM models
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv"
cars <- h2o.importFile(f)
predictors <- c("displacement", "power", "weight", "acceleration", "year")
response <- "cylinders"
cars_split <- h2o.splitFrame(data = cars, ratios = 0.8, seed = 1234)
train <- cars_split[[1]]
valid <- cars_split[[2]]
cars_glm <- h2o.glm(seed = 1234, 
                    lambda=0.0,
                    compute_p_values=TRUE,
                    x = predictors, 
                    y = response, 
                    training_frame = train, 
                    validation_frame = valid)
h2o.coef_with_p_values(cars_glm)
}
}
