% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.merge}
\alias{h2o.merge}
\title{Merge Two H2O Data Frames}
\usage{
h2o.merge(x, y, all.x = FALSE, all.y = FALSE, by.x = NULL, by.y = NULL,
  method = "hash")
}
\arguments{
\item{x,y}{H2OFrame objects}

\item{all.x}{If all.x is true, all rows in the x will be included, even if there is no matching
row in y, and vice-versa for all.y.}

\item{all.y}{see all.x}

\item{by.x}{x columns used for merging.}

\item{by.y}{y columns used for merging.}

\item{method}{auto, radix, or hash (default)}
}
\description{
Merges two H2OFrame objects by shared column names. Unlike the
base R implementation, \code{h2o.merge} only supports merging through shared
column names.
}
\details{
In order for \code{h2o.merge} to work in multinode clusters, one of the
datasets must be small enough to exist in every node. Currently, this
function only supports \code{all.x = TRUE}. All other permutations will fail.
}
\examples{
\donttest{
h2o.init()
left <- data.frame(fruit = c('apple', 'orange', 'banana', 'lemon', 'strawberry', 'blueberry'),
color = c('red', 'orange', 'yellow', 'yellow', 'red', 'blue'))
right <- data.frame(fruit = c('apple', 'orange', 'banana', 'lemon', 'strawberry', 'watermelon'),
citrus = c(FALSE, TRUE, FALSE, TRUE, FALSE, FALSE))
l.hex <- as.h2o(left)
r.hex <- as.h2o(right)
left.hex <- h2o.merge(l.hex, r.hex, all.x = TRUE)
}
}

