% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h3_algorithms.R
\name{get_centerchild}
\alias{get_centerchild}
\title{get central child H3 cell index}
\usage{
get_centerchild(h3_address = NULL, res = NULL, simple = TRUE)
}
\arguments{
\item{h3_address}{Character; 15-character index generated by H3.}

\item{res}{Integer; Desired H3 resolution. See
\url{https://h3geo.org/docs/core-library/restable/} for allowable values and related dimensions.}

\item{simple}{Logical; whether to return a vector of outputs or a data frame
containing both inputs and outputs.}
}
\value{
By default, a list of length(h3_address). Each list element contains
  a vector of H3 cells.
}
\description{
This function returns the central child of a particular H3 cell index at the
requested resolution.
}
\examples{
# What is the central child of this resolution 6 index at resolution 8?
get_centerchild(h3_address = '86be8d12fffffff', res = 8)
}
