% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unidirectional_edges.R
\name{are_neighbours}
\alias{are_neighbours}
\title{check if H3 cells are neighbours}
\usage{
are_neighbours(origin = NULL, destination = NULL, simple = TRUE)
}
\arguments{
\item{origin}{Character; 15-character cell index generated by H3. A vector of
indexes can also be supplied.}

\item{destination}{Character; 15-character cell index generated by H3. A vector
of indexes can also be supplied.}

\item{simple}{Logical; whether to return a vector of outputs or a data frame
containing both inputs and outputs.}
}
\value{
Logical; TRUE if neighbours.
}
\description{
This function checks whether two H3 cells share an edge.
}
\note{
\itemize{
\item{The number of indexes supplied to origin and destination must be
equal.}
\item{This function will always return false if the indexes are of different
resolutions.}
 }
}
\examples{
# Are the following cells neighbours?
are_neighbours(origin = '86be8d12fffffff', destination = '86be8d127ffffff')

}
