% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tikzutils.R
\name{tikz.finalize}
\alias{tikz.finalize}
\title{tikz.finalize}
\usage{
tikz.finalize(tikzfiles, crop = TRUE, margins = 0, clean = TRUE)
}
\arguments{
\item{tikzfiles}{a list with members $pdf, $tex, $aux and $log, returned by
\code{tikz.init} which must be passed to \code{tikz.finalize}}

\item{crop}{boolean indicating whether \code{pdfcrop} should be called on
the resulting pdf ( existence of \code{pdfcrop} is checked before the
command is called ), default TRUE}

\item{margins}{margins argument for pdfcrop command, should be passed as a
string consisting of one or multiple numbers (e.g. "10" or "10.5 7.5 6.2
10"), default 0}

\item{clean}{boolean indicating whether temporary files, e.g.
"basename.tex", "basename.aux" and "basename.log" should be deleted after
the pdf has been generated, default TRUE}
}
\value{
No return value, but the output PDF will be created and cropped.
}
\description{
initialize and finalize a \code{tikzDevice} and carry out optional
post-processing
}
\details{
Convenience Functions for \code{tikzDevice}
}
\seealso{
\code{\link{tikz.init}}

Other tikzutils: 
\code{\link{tikz.init}()}
}
\author{
Bartosz Kostrzewa, \email{bartosz.kostrzewa@desy.de}
}
\concept{tikzutils}
\keyword{file}
