% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_binary_matrix.R
\name{create_binary_matrix}
\alias{create_binary_matrix}
\title{Create binary data matrix}
\usage{
create_binary_matrix(x, cutoff, control, sample, gene, perc_susc)
}
\arguments{
\item{x}{a \code{data.frame} containing the data.}

\item{cutoff}{value for percent susceptible cutoff. Numeric.}

\item{control}{value used to denote the susceptible control in the \code{gene}
column. Character.}

\item{sample}{column providing the unique identification for each sample
being tested. Character.}

\item{gene}{column providing the gene(s) being tested. Character.}

\item{perc_susc}{column providing the percent susceptible reactions.
Character.}
}
\value{
\code{create_binary_matrix} returns a binary matrix of pathotype data as
a \link{matrix} object
}
\description{
Creates a binary data matrix from pathotype data representing
the pathotype of each isolate. This binary data matrix can be used to
visualize beta-diversity of pathotypes using \CRANpkg{vegan} and \CRANpkg{ape}.
}
\examples{

# Using the built-in data set, P_sojae_survey
data(P_sojae_survey)

P_sojae_survey

# calculate susceptibilities with a 60 \% cutoff value
final_matrix <- create_binary_matrix(x = P_sojae_survey,
                                    cutoff = 60,
                                    control = "susceptible",
                                    sample = "Isolate",
                                    gene = "Rps",
                                    perc_susc = "perc.susc")
final_matrix

}
