% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_age_model.R
\name{fit_age_model}
\alias{fit_age_model}
\title{Fit a model (or age-length key) that will be used to estimate ages}
\usage{
fit_age_model(
  data,
  model = "halk",
  levels = NULL,
  age_col = "age",
  size_col = "length",
  ...
)
}
\arguments{
\item{data}{An object of class data.frame}

\item{model}{Character. The model type to fit. Options are 'alk',
'halk', 'rf' (for random forest), 'gbm' (for gradient boosting machine)}

\item{levels}{Character vector. The levels that the age estimating model
will fit to. Each level specified must correspond to a column in \code{data}.
For models 'alk' and 'halk' an age-length key gets created
at each level. For 'rf' and 'gbm' the levels get converted to a formula
(see Details)}

\item{age_col}{Character. The name of the column in data that contains ages}

\item{size_col}{Character. The name of the column in data that contains sizes}

\item{...}{Additional arguments passed onto the various methods}
}
\value{
An object of the appropriate model type according to what was
provided by the \code{model} argument
}
\description{
This function will create the appropriate model (or age-length key) that can
then be used to predict ages based on length (or sizes, more generally). The
model types that are currently available are 'age-length key', a 'smart
age-length key' (see Details), random forest, and gradient boosting machine.
}
\details{
\code{fit_age_model} will take the provided length-at-age data and create a
model for predicting ages based on length (or whatever is specific as the
\code{size_col} argument). The different methods for doing this are:
\itemize{
  \item{alk}{ -- a basic age-length key}
  \item{smart_alk}{ -- a more advanced method that creates an
  age-length key from data when enough is available, but borrows data from
  elsewhere when it's not. This option requires that you specify levels at
  which to fit each alk (i.e. species, county, waterbody, year, etc.).
  As an example, if species, county, county, and waterbody are each specified
  as levels, then \code{fit_age_model} will create age-length keys for each
  waterbody, for each county, and ultimately for each species. The highest
  level most general ALK is created at the first level specified.}
  \item{rf}{ -- a random forest model that includes any levels specified in
  \code{levels}}
  \item{gbm}{ -- a gradient boosting machine model that includes any levels
  specified in \code{levels}}
}

For the rf and gbm models, the strings specified in levels get converted to
and added to the formula passed those models. For example, if
levels = c("spp", "county", "waterbody"), then the resulting formula in the
call to the model would be age ~ length + spp + county + waterbody.
}
\examples{
spp_halk <- fit_age_model(spp_data, levels = "spp")
}
