% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_format.R
\name{get_cluster_fill_counts}
\alias{get_cluster_fill_counts}
\title{Get Cluster Fill Counts}
\usage{
get_cluster_fill_counts(df)
}
\arguments{
\item{df}{A data frame with columns \code{docname} and \code{cluster}. Each row
corresponding to a graph and lists the document from which the graph was
obtained, and the cluster to which that graph is assigned. Optionally, the
data frame might also have \code{writer} and \code{doc} columns. If present, \code{writer}
lists the writer ID of each document and \code{doc} is an identifier to
distinguish between different documents from the same writer.}
}
\value{
A dataframe of cluster fill counts for each document in the input
data frame.
}
\description{
\code{get_cluster_fill_counts()} creates a data frame that shows the number of
graphs in each cluster for each input document.
}
\examples{
docname <- c(rep('doc1',20), rep('doc2', 20), rep('doc3', 20))
writer <- c(rep(1, 20), rep(2, 20), rep(3, 20))
doc <- c(rep(1, 20), rep(2, 20), rep(3, 20))
cluster <- sample(3, 60, replace=TRUE)
df <- data.frame(docname, writer, doc, cluster)
get_cluster_fill_counts(df)

}
