% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blueprint-formula-default.R,
%   R/blueprint-recipe-default.R, R/blueprint-xy-default.R
\name{new_default_formula_blueprint}
\alias{new_default_formula_blueprint}
\alias{new_default_recipe_blueprint}
\alias{new-default-blueprint}
\alias{new_default_xy_blueprint}
\title{Create a new default blueprint}
\usage{
new_default_formula_blueprint(
  mold,
  forge,
  intercept = FALSE,
  allow_novel_levels = FALSE,
  ptypes = NULL,
  formula = NULL,
  indicators = "traditional",
  terms = list(predictors = NULL, outcomes = NULL),
  ...,
  subclass = character()
)

new_default_recipe_blueprint(
  mold,
  forge,
  intercept = FALSE,
  allow_novel_levels = FALSE,
  fresh = TRUE,
  ptypes = NULL,
  recipe = NULL,
  extra_role_ptypes = NULL,
  ...,
  subclass = character()
)

new_default_xy_blueprint(
  mold,
  forge,
  intercept = FALSE,
  allow_novel_levels = FALSE,
  ptypes = NULL,
  ...,
  subclass = character()
)
}
\arguments{
\item{mold}{A named list with two elements, \code{clean} and \code{process}, see
the \code{\link[=new_blueprint]{new_blueprint()}} section, Mold Functions, for details.}

\item{forge}{A named list with two elements, \code{clean} and \code{process}, see
the \code{\link[=new_blueprint]{new_blueprint()}} section, Forge Functions, for details.}

\item{intercept}{A logical. Should an intercept be included in the
processed data? This information is used by the \code{process} function
in the \code{mold} and \code{forge} function list.}

\item{allow_novel_levels}{A logical. Should novel factor levels be allowed at
prediction time? This information is used by the \code{clean} function in the
\code{forge} function list, and is passed on to \code{\link[=scream]{scream()}}.}

\item{ptypes}{Either \code{NULL}, or a named list with 2 elements, \code{predictors}
and \code{outcomes}, both of which are 0-row tibbles. \code{ptypes} is generated
automatically at \code{\link[=mold]{mold()}} time and is used to validate \code{new_data} at
prediction time. At \code{\link[=mold]{mold()}} time, the information found in
\code{blueprint$mold$process()$ptype} is used to set \code{ptypes} for the \code{blueprint}.}

\item{formula}{Either \code{NULL}, or a formula that specifies how the
predictors and outcomes should be preprocessed. This argument is set
automatically at \code{\link[=mold]{mold()}} time.}

\item{indicators}{A single character string. Control how factors are
expanded into dummy variable indicator columns. One of:
\itemize{
\item \code{"traditional"} - The default. Create dummy variables using the
traditional \code{\link[=model.matrix]{model.matrix()}} infrastructure. Generally this creates
\code{K - 1} indicator columns for each factor, where \code{K} is the number of
levels in that factor.
\item \code{"none"} - Leave factor variables alone. No expansion is done.
\item \code{"one_hot"} - Create dummy variables using a one-hot encoding approach
that expands unordered factors into all \code{K} indicator columns, rather than
\code{K - 1}.
}}

\item{terms}{A named list of two elements, \code{predictors} and \code{outcomes}. Both
elements are \code{terms} objects that describe the terms for the outcomes and
predictors separately. This argument is set automatically at \code{\link[=mold]{mold()}} time.}

\item{...}{Name-value pairs for additional elements of blueprints that
subclass this blueprint.}

\item{subclass}{A character vector. The subclasses of this blueprint.}

\item{fresh}{Should already trained operations be re-trained when \code{prep()} is
called?}

\item{recipe}{Either \code{NULL}, or an unprepped recipe. This argument is set
automatically at \code{\link[=mold]{mold()}} time.}

\item{extra_role_ptypes}{A named list. The names are the unique non-standard
recipe roles (i.e. everything except \code{"predictors"} and \code{"outcomes"}). The
values are prototypes of the original columns with that role. These are
used for validation in \code{forge()}.}
}
\description{
This page contains the constructors for the default blueprints. They can be
extended if you want to add extra behavior on top of what the default
blueprints already do, but generally you will extend the non-default versions
of the constructors found in the documentation for \code{\link[=new_blueprint]{new_blueprint()}}.
}
