% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemlist.R
\encoding{UTF-8}
\name{itemlist}
\alias{itemlist}
\title{Objects to be used for restricted layout structure Hasse diagram}
\usage{
itemlist(datadesign, randomfacsid = NULL)
}
\arguments{
\item{datadesign}{A data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables/factors 
in the experimental design. The dataframe should only include the variables/factors/columns that the user wants to evaluate in the 
consecutive \code{\link[hassediagrams]{hasserls}} function to generate the Hasse diagram of the restricted layout structure.}

\item{randomfacsid}{An optional vector specifying whether the factors are defined as fixed (entry = 0) or random (entry = 1). 
The default choice is \code{NULL} and the function automatically sets all entries to 0. The length of the vector should be equal to the number of variables/factors in the design, i.e., the length of the vector should be equal to the number of columns of the argument \code{datadesign}.}
}
\value{
The function returns an object of class \code{"rls"} which is a list with the following components:

 \code{design} - The design dataframe containing all of the factors present in the layout structure. This is identical to the input argument \code{datadesign}.
 
 \code{finaleffectsnames} - A character vector consisting of all structural objects (factors and generalised factors) in the layout structure.
 
 \code{finalstructure} - A table that shows the relationships between the structural objects in the layout structure.
 
 \code{finaleffects} - A vector containing the final factor orders.
 
 \code{finalrandomeffects} - A vector containing 0 or 1 entries for factors or generalised factors corresponding to fixed (entry = 0) or random (entry = 1) effects.
 
 \code{confoundings} - Defines the equivalent factors and generalised factors.
 
 \code{nfactors} - The number of factors/variables of the design dataframe.
 
 \code{outputlistip1} - A list of items required to generate the restricted layout structure.
 
 \code{nestednames} - List of matrices containing the nested version of the factor and generalised factor names.
 
 \code{TransferObject} - A Nx2 matrix where N equals the total number of structural objects. The first column contains the structural objects 
in the layout structure, and the second column has "Mean" for the first entry and "NULL" for the remaining entries.
}
\description{
Returns an object of class \code{"rls"} that contains the structural objects of the layout structure. The output can be used in a consecutive function to generate the Hasse diagram of the restricted layout structure of the experimental design.
}
\details{
The function requires a dataframe containing the variables corresponding to the experimental factors only (i.e., no response variables). 
Using the \code{randomfacsid} argument, the factors and generalised factors that correspond to random effects can be identified.
}
\examples{
\donttest{
# Examples using built-in data: concrete, dental, human, analytical

# Fractional factorial design for asphalt concrete production
concrete_objects <- itemlist(datadesign=concrete)
print(concrete_objects)

# Crossover design for a dental study
dental_objects <- itemlist(datadesign=dental, randomfacsid=c(0,1,0,0,0))
summary(dental_objects)

# Block design for an experiment assessing human-computer interaction
human_objects <- itemlist(datadesign=human, randomfacsid=c(1,1,0,0,0,0,1))
print(human_objects)

# Cross-nested design for an analytical method investigation
analytical_objects <- itemlist(datadesign=analytical, 
                               randomfacsid=c(0,0,1,1,1,0,0,0))
summary(analytical_objects)

# Examples using data from the dae package (conditionally loaded)
if (requireNamespace("dae", quietly = TRUE)) {
  data(BIBDWheat.dat, package = "dae")
  BIBDWheat <- BIBDWheat.dat[, -4]
  BIBDWheat$Plots <- c(1:30)
  BIBDWheat_objects <- itemlist(datadesign=BIBDWheat)
  print(BIBDWheat_objects)
}
}

}
\references{
Bate, S.T. and Chatfield, M.J. (2016a), Identifying the structure of the experimental design. Journal of Quality Technology, 48, 343-364.

Bate, S.T. and Chatfield, M.J. (2016b), Using the structure of the experimental design and the randomization to construct a mixed model. Journal of Quality Technology, 48, 365-387.

Box, G.E.P., Hunter, J.S., and Hunter, W.G., (1978), Statistics for Experimenters. Wiley.

Joshi, D.D. (1987), Linear Estimation and Design of Experiments. Wiley Eastern, New Delhi.

Williams, E.R., Matheson, A.C. and Harwood, C.E. (2002), Experimental design and analysis for tree improvement. 2nd edition. CSIRO, Melbourne, Australia.
}
\author{
Damianos Michaelides, Simon Bate, and Marion Chatfield
}
