% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretize.R
\name{discrete}
\alias{discrete}
\title{Discretizes a Hawkes simulation}
\usage{
discrete(hawkes, length = NULL, binsize = NULL)
}
\arguments{
\item{hawkes}{An object created by the function \code{hawkes}}

\item{length}{(Either) The length for the output vector}

\item{binsize}{(Either) The binsize for the discretization}
}
\value{
The vector of counts
}
\description{
Discretizes a Hawkes simulation
}
\examples{
x = hawkes(100, fun=1, repr=0.5, family="exp", rate=2)
y = discrete(x, length=100)
z = discrete(x, binsize=1)
all(y == z)
}
