% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data60UK.R
\name{catalogueData60UK}
\alias{catalogueData60UK}
\title{Interface for the Data60UK database catalogue}
\usage{
catalogueData60UK(bbox = NULL, columnName = NULL, columnValue = NULL)
}
\arguments{
\item{bbox}{bounding box, a list made of 4 elements: minimum longitude (lonMin), minimum latitude (latMin), maximum longitude (lonMax), maximum latitude (latMax)}

\item{columnName}{name of the column to filter}

\item{columnValue}{value to look for in the column named columnName}
}
\value{
This function returns a data frame made of 5 columns: "id" (hydrometric reference number), "name", "location", "Latitude", "Longitude" and "area".
}
\description{
This function interfaces the Data60UK database catalogue (available from http://www.nwl.ac.uk/ih/nrfa/pub/index.html) containing 61 datasets. Dataset catalogue is available from http://www.nwl.ac.uk/ih/nrfa/pub/data.html.
}
\examples{
\dontrun{
  # Retrieve the whole catalogue
  catalogueData60UK()

  # Define a bounding box
  bbox <- list(lonMin=-3.82,latMin=52.41,lonMax=-3.63,latMax=52.52)

  # Filter the catalogue
  catalogueData60UK(bbox)
  catalogueData60UK(columnName="id",columnValue="62001")
}

}
\author{
Claudia Vitolo
}

