// (c) The HDF Group
#ifndef H5B2private_H
#define H5B2private_H
#include "H5ACprivate.h"
#include "H5Fprivate.h"
typedef enum H5B2_subid_t {
    H5B2_TEST_ID = 0,
    H5B2_FHEAP_HUGE_INDIR_ID,
    H5B2_FHEAP_HUGE_FILT_INDIR_ID,
    H5B2_FHEAP_HUGE_DIR_ID,
    H5B2_FHEAP_HUGE_FILT_DIR_ID,
    H5B2_GRP_DENSE_NAME_ID,
    H5B2_GRP_DENSE_CORDER_ID,
    H5B2_SOHM_INDEX_ID,
    H5B2_ATTR_DENSE_NAME_ID,
    H5B2_ATTR_DENSE_CORDER_ID,
    H5B2_CDSET_ID,
    H5B2_CDSET_FILT_ID,
    H5B2_TEST2_ID,
    H5B2_NUM_BTREE_ID
} H5B2_subid_t;
typedef int (*H5B2_operator_t)(const void *record, void *op_data);
typedef herr_t (*H5B2_found_t)(const void *record, void *op_data);
typedef herr_t (*H5B2_modify_t)(void *record, void *op_data, bool *changed);
typedef herr_t (*H5B2_remove_t)(const void *record, void *op_data);
typedef enum H5B2_compare_t {
    H5B2_COMPARE_LESS,
    H5B2_COMPARE_GREATER
} H5B2_compare_t;
typedef struct H5B2_class_t H5B2_class_t;
struct H5B2_class_t {
    H5B2_subid_t id;
    const char  *name;
    size_t       nrec_size;
    void *(*crt_context)(void *udata);
    herr_t (*dst_context)(void *ctx);
    herr_t (*store)(void *nrecord, const void *udata);
    herr_t (*compare)(const void *rec1, const void *rec2, int *result);
    herr_t (*encode)(uint8_t *raw, const void *record,
                     void *ctx);
    herr_t (*decode)(const uint8_t *raw, void *record,
                     void *ctx);
    herr_t (*debug)(FILE *stream, int indent, int fwidth,
                    const void *record, const void *ctx);
};
typedef struct H5B2_create_t {
    const H5B2_class_t *cls;
    uint32_t            node_size;
    uint32_t            rrec_size;
    uint8_t             split_percent;
    uint8_t             merge_percent;
} H5B2_create_t;
typedef struct H5B2_stat_t {
    unsigned depth;
    hsize_t  nrecords;
} H5B2_stat_t;
typedef struct H5B2_t H5B2_t;
H5_DLL H5B2_t *H5B2_create(H5F_t *f, const H5B2_create_t *cparam, void *ctx_udata);
H5_DLL H5B2_t *H5B2_open(H5F_t *f, haddr_t addr, void *ctx_udata);
H5_DLL herr_t  H5B2_get_addr(const H5B2_t *bt2, haddr_t *addr);
H5_DLL herr_t  H5B2_insert(H5B2_t *bt2, void *udata);
H5_DLL herr_t  H5B2_iterate(H5B2_t *bt2, H5B2_operator_t op, void *op_data);
H5_DLL herr_t  H5B2_find(H5B2_t *bt2, void *udata, bool *found, H5B2_found_t op, void *op_data);
H5_DLL herr_t  H5B2_index(H5B2_t *bt2, H5_iter_order_t order, hsize_t idx, H5B2_found_t op, void *op_data);
H5_DLL herr_t  H5B2_neighbor(H5B2_t *bt2, H5B2_compare_t range, void *udata, H5B2_found_t op, void *op_data);
H5_DLL herr_t  H5B2_modify(H5B2_t *bt2, void *udata, H5B2_modify_t op, void *op_data);
H5_DLL herr_t  H5B2_update(H5B2_t *bt2, void *udata, H5B2_modify_t op, void *op_data);
H5_DLL herr_t  H5B2_remove(H5B2_t *b2, void *udata, H5B2_remove_t op, void *op_data);
H5_DLL herr_t  H5B2_remove_by_idx(H5B2_t *bt2, H5_iter_order_t order, hsize_t idx, H5B2_remove_t op,
                                  void *op_data);
H5_DLL herr_t  H5B2_get_nrec(const H5B2_t *bt2, hsize_t *nrec);
H5_DLL herr_t  H5B2_size(H5B2_t *bt2, hsize_t *btree_size);
H5_DLL herr_t  H5B2_close(H5B2_t *bt2);
H5_DLL herr_t  H5B2_delete(H5F_t *f, haddr_t addr, void *ctx_udata, H5B2_remove_t op, void *op_data);
H5_DLL herr_t  H5B2_depend(H5B2_t *bt2, H5AC_proxy_entry_t *parent);
H5_DLL herr_t  H5B2_patch_file(H5B2_t *fa, H5F_t *f);
H5_DLL herr_t H5B2_stat_info(H5B2_t *bt2, H5B2_stat_t *info);
#endif
