/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5Pmodule.h" 

#include "H5private.h"  
#include "H5Eprivate.h" 
#include "H5Lprivate.h" 
#include "H5Ppkg.h"     

#define H5L_CRT_INTERMEDIATE_GROUP_SIZE sizeof(unsigned)
#define H5L_CRT_INTERMEDIATE_GROUP_DEF  0
#define H5L_CRT_INTERMEDIATE_GROUP_ENC  H5P__encode_unsigned
#define H5L_CRT_INTERMEDIATE_GROUP_DEC  H5P__decode_unsigned

static herr_t H5P__lcrt_reg_prop(H5P_genclass_t *pclass);

const H5P_libclass_t H5P_CLS_LCRT[1] = {{
    "link create",        
    H5P_TYPE_LINK_CREATE, 

    &H5P_CLS_STRING_CREATE_g,  
    &H5P_CLS_LINK_CREATE_g,    
    &H5P_CLS_LINK_CREATE_ID_g, 
    &H5P_LST_LINK_CREATE_ID_g, 
    H5P__lcrt_reg_prop,        

    NULL, 
    NULL, 
    NULL, 
    NULL, 
    NULL, 
    NULL  
}};

static const unsigned H5L_def_intmd_group_g =
    H5L_CRT_INTERMEDIATE_GROUP_DEF; 

static herr_t
H5P__lcrt_reg_prop(H5P_genclass_t *pclass)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (H5P__register_real(pclass, H5L_CRT_INTERMEDIATE_GROUP_NAME, H5L_CRT_INTERMEDIATE_GROUP_SIZE,
                           &H5L_def_intmd_group_g, NULL, NULL, NULL, H5L_CRT_INTERMEDIATE_GROUP_ENC,
                           H5L_CRT_INTERMEDIATE_GROUP_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5Pset_create_intermediate_group(hid_t plist_id, unsigned crt_intmd_group)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_LINK_CREATE, false)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    crt_intmd_group = (unsigned)(crt_intmd_group > 0 ? 1 : 0);
    if (H5P_set(plist, H5L_CRT_INTERMEDIATE_GROUP_NAME, &crt_intmd_group) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set intermediate group creation flag");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_create_intermediate_group(hid_t plist_id, unsigned *crt_intmd_group )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_LINK_CREATE, true)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (crt_intmd_group)
        if (H5P_get(plist, H5L_CRT_INTERMEDIATE_GROUP_NAME, crt_intmd_group) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get intermediate group creation flag");

done:
    FUNC_LEAVE_API(ret_value)
} 
