% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes_H5R.R
\name{H5R_functions}
\alias{H5R_functions}
\alias{is.H5R}
\alias{is.H5R_OBJECT}
\alias{is.H5R_DATASET_REGION}
\alias{names.H5R}
\alias{length.H5R}
\alias{[.H5R}
\alias{[<-.H5R}
\alias{c.H5R}
\alias{dim.H5R}
\alias{dim<-.H5R}
\alias{t.H5R}
\alias{dimnames.H5R}
\alias{dimnames<-.H5R}
\alias{cbind.H5R}
\alias{rbind.H5R}
\alias{print.H5R}
\alias{format.H5R}
\alias{as.data.frame.H5R}
\alias{as.vector.H5R}
\title{Various functions for \code{H5R} objects}
\usage{
is.H5R(x)

is.H5R_OBJECT(x)

is.H5R_DATASET_REGION(x)

\method{names}{H5R}(x)

\method{length}{H5R}(x)

\method{[}{H5R}(x, i, j, ..., drop = TRUE)

\method{[}{H5R}(x, i, ...) <- value

\method{c}{H5R}(..., recursive = FALSE)

\method{dim}{H5R}(x)

\method{dim}{H5R}(x) <- value

\method{t}{H5R}(x)

\method{dimnames}{H5R}(x)

\method{dimnames}{H5R}(x) <- value

\method{cbind}{H5R}(..., deparse.level = 1)

\method{rbind}{H5R}(..., deparse.level = 1)

\method{print}{H5R}(x, ...)

\method{format}{H5R}(x, ...)

\method{as.data.frame}{H5R}(x, row.names = NULL, optional = FALSE, ...,
  nm = paste(deparse(substitute(x), width.cutoff = 500L), collapse = " "))

\method{as.vector}{H5R}(x, mode = "any")
}
\arguments{
\item{x}{Object of type \code{H5R}}

\item{i}{First dimension}

\item{j}{Second dimension}

\item{...}{Any other dimensions (for subsetting), or objects to concatenate (for \code{c})
or combine by row/col (for \code{cbind} or \code{rbind}) or ignored (for \code{print} and \code{format})}

\item{drop}{Should dimensions of size 1 be dropped; LOGICAL}

\item{value}{The value in an assignment}

\item{recursive}{Ignored here}

\item{deparse.level}{integer controlling the construction of labels in the case of non-matrix-like arguments (for the default method):
'deparse.level = 0' constructs no labels; the default, 'deparse.level = 1' constructs labels from the argument
names}

\item{row.names}{\code{NULL} or a character vector giving the row names for the
data frame.  Missing values are not allowed.}

\item{optional}{logical. If \code{TRUE}, setting row names and converting column
names (to syntactic names: see \code{make.names}) is optional.}

\item{nm}{The column names to use}

\item{mode}{Only 'any' supported}

\item{width.cutoff}{ignored}

\item{collapse}{ignored}
}
\value{
Depending on the function
}
\description{
Various functions for \code{H5R} objects
}
\details{
\describe{
  \item{is.H5R}{Check if object inherits from \code{H5R}}
  \item{is.H5R_OBJECT}{Check if object inherits from \code{H5R_OBJECT}}
  \item{is.H5R_DATASET_REGION}{Check if object inherits from \code{H5R_DATASET_REGION}}
  \item{names.H5R}{Returns the names of the elements of the vector}
  \item{length.H5R}{Returns the length of the vector}
  \item{[.H5R}{Array subsetting function}
  \item{[<-.H5R}{Array subset assignment}
  \item{c.H5R}{Concatenation of \code{H5R} vectors}
  \item{dim.H5R}{Dimensionality of the object}
  \item{dim<-.H5R}{Assign dimension of the object}
  \item{t.H5R}{Transpose a matrix of \code{H5R} objects}
  \item{dimnames.H5R}{Get the dimnames of the object}
  \item{dimnames<-.H5R}{Set the dimnames of the object}
  \item{cbind.H5R}{cbind functionality for \code{H5R} objects}
  \item{rbind.H5R}{rbind functionality for \code{H5R} objects}
  \item{print.H5R}{Printing of an object of class \code{h5R}}
  \item{format.H5R}{Formatting of an H5R object}
  \item{as.data.frame.H5R}{Coerce an \code{H5R} object to a data.frame}
  \item{as.vector.H5R}{Coerce to a vector}
  \item{as.data.frame.H5R}{Coerces the object to a data.frame}
  \item{as.vector.H5R}{Coerces to a vector}
}
}
\author{
Holger Hoefling
}
