% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlassoIVselectZ.R
\name{rlassoIVselectZ}
\alias{rlassoIVselectZ}
\alias{rlassoIVselectZ.default}
\alias{rlassoIVselectZ.formula}
\title{Instrumental Variable Estimation with Lasso}
\usage{
rlassoIVselectZ(x, ...)

\method{rlassoIVselectZ}{default}(x, d, y, z, post = TRUE, intercept = TRUE,
  ...)

\method{rlassoIVselectZ}{formula}(formula, data, post = TRUE,
  intercept = TRUE, ...)
}
\arguments{
\item{x}{exogenous variables in the structural equation (matrix)}

\item{d}{endogenous variables in the structural equation (vector or matrix)}

\item{y}{outcome or dependent variable in the structural equation (vector or matrix)}

\item{z}{set of potential instruments for the endogenous variables.
Exogenous variables serve as their own instruments.}

\item{post}{logical. If \code{TRUE}, post-lasso estimation is conducted.}

\item{intercept}{logical. If \code{TRUE}, intercept is included in the second stage equation.}

\item{formula}{An object of class \code{Formula} of the form " y ~ x + d | x + z" with y the outcome variable,
d endogenous variable, z instrumental variables, and x exogenous variables.}

\item{data}{An optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. 
If not found in data, the variables are taken from environment(formula), typically the environment from which \code{rlassoIVselectZ} is called.}

\item{\dots}{arguments passed to the function \code{rlasso}.}
}
\value{
An object of class \code{rlassoIVselectZ} containing at least the following
components: \item{coefficients}{estimated parameter vector}
\item{vcov}{variance-covariance matrix} \item{residuals}{
residuals} \item{samplesize}{sample size}
}
\description{
This function selects the instrumental variables in the first stage by
Lasso. First stage predictions are then used in the second stage as optimal
instruments to estimate the parameter vector. The function returns an element of class \code{rlassoIVselectZ}
}
\details{
The implementation follows the procedure described in Belloni et al. (2012).
Option \code{post=TRUE} conducts post-lasso estimation, i.e. a refit of the
model with the selected variables, to estimate the optimal instruments. The
parameter vector of the structural equation is then fitted by two-stage
least square (tsls) estimation.
}
\references{
D. Belloni, D. Chen, V. Chernozhukov and C. Hansen (2012).
Sparse models and methods for optimal instruments with an application to
eminent domain. \emph{Econometrica} 80 (6), 2369--2429.
}

