% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature-availability-profiler.R
\name{featureAvailabilityProfiler}
\alias{featureAvailabilityProfiler}
\title{Calculate and plot data availability over time}
\usage{
featureAvailabilityProfiler(df, startDateColumn = "AdmitDTS",
  lastLoadDateColumn = "LastLoadDTS", plotProfiler = TRUE)
}
\arguments{
\item{df}{A dataframe}

\item{startDateColumn}{Optional string of the column name, representing the 
date of the starting event of interest (e.g., patient admit)}

\item{lastLoadDateColumn}{Optional string of the column name, representing
the date the row was loaded into the final dataset (i.e., via daily ETL)}

\item{plotProfiler}{Default is TRUE. Whether to plot profiler results}
}
\value{
a list, that has as many vectors as columns in the original 
dataframe, with each vector holding the percentage full for each hour
}
\description{
Helps you determine how much data is present in each feature, 
by hour, after a particular event (like patient admit)
}
\examples{
df <- data.frame(a = c(2,1,3,5,4,NA,7,NA),
                 b = c(0.7,-2,NA,-4,-5,-6,NA,NA),
                 c = c(100,300,200,NA,NA,NA,NA,500),
                 d = c(407,500,506,504,NA,NA,NA,405),
                 admit = c('2012-01-01 00:00:00','2012-01-01 00:00:00',
                           '2012-01-01 12:00:00','2012-01-01 12:00:00',
                           '2012-01-02 00:00:00','2012-01-02 00:00:00',
                           '2012-01-02 12:00:00','2012-01-02 12:00:00'),
                 loaded = c('2012-01-03 00:00:00','2012-01-03 00:00:00',
                            '2012-01-03 00:00:00','2012-01-03 00:00:00',
                            '2012-01-03 00:00:00','2012-01-03 00:00:00',
                            '2012-01-03 00:00:00','2012-01-03 00:00:00'))
str(df)
head(df)

d <- featureAvailabilityProfiler(df = df,
                                 startDateColumn = 'admit',
                                 lastLoadDateColumn = 'loaded')
d # Look at the data in the console                                
}
\references{
\url{http://healthcare.ai}
}
\seealso{
\code{\link{healthcareai}}
}
