% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_train_test.R
\name{split_train_test}
\alias{split_train_test}
\title{Split data into training and test data frames}
\usage{
split_train_test(d, outcome, percent_train = 0.8, seed)
}
\arguments{
\item{d}{Data frame}

\item{outcome}{Target column, unquoted. Split will be stratified across this
variable}

\item{percent_train}{Proportion of rows in d to put into training. Default is 0.8}

\item{seed}{Optional, if provided the function will return the same split
each time it is called}
}
\value{
A list of two data frames with names train and test
}
\description{
Split data into training and test data frames
}
\details{
This function wraps `caret::createDataPartition`.
}
\examples{
split_train_test(mtcars, am, .9)
}
