% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfs-prophet-reg.R
\name{ts_wfs_prophet_reg}
\alias{ts_wfs_prophet_reg}
\title{Auto PROPHET Regression Workflowset Function}
\usage{
ts_wfs_prophet_reg(
  .model_type = "all_engines",
  .recipe_list,
  .growth = NULL,
  .changepoint_num = 25,
  .changepoint_range = 0.8,
  .seasonality_yearly = "auto",
  .seasonality_weekly = "auto",
  .seasonality_daily = "auto",
  .season = "additive",
  .prior_scale_changepoints = 25,
  .prior_scale_seasonality = 1,
  .prior_scale_holidays = 1,
  .logistic_cap = NULL,
  .logistic_floor = NULL,
  .trees = 50,
  .min_n = 10,
  .tree_depth = 5,
  .learn_rate = 0.01,
  .loss_reduction = NULL,
  .stop_iter = NULL
)
}
\arguments{
\item{.model_type}{This is where you will set your engine. It uses
\code{\link[modeltime:prophet_reg]{modeltime::prophet_reg()}} under the hood and can take one of the following:
\itemize{
\item "prophet"
Or \code{\link[modeltime:prophet_boost]{modeltime::prophet_boost()}} under the hood and can take one of the following:
\item "prophet_xgboost"
You can also choose:
\item "all_engines" - This will make a model spec for all available engines.
}}

\item{.recipe_list}{You must supply a list of recipes. list(rec_1, rec_2, ...)}

\item{.growth}{String 'linear' or 'logistic' to specify a linear or logistic trend.}

\item{.changepoint_num}{Number of potential changepoints to include for modeling trend.}

\item{.changepoint_range}{Adjusts the flexibility of the trend component by
limiting to a percentage of data before the end of the time series. 0.80
means that a changepoint cannot exist after the first 80\% of the data.}

\item{.seasonality_yearly}{One of "auto", TRUE or FALSE. Set to FALSE for \code{prophet_xgboost}.
Toggles on/off a seasonal component that models year-over-year seasonality.}

\item{.seasonality_weekly}{One of "auto", TRUE or FALSE. Toggles on/off a
seasonal component that models week-over-week seasonality. Set to FALSE for \code{prophet_xgboost}}

\item{.seasonality_daily}{One of "auto", TRUE or FALSE. Toggles on/off a
seasonal componet that models day-over-day seasonality. Set to FALSE for \code{prophet_xgboost}}

\item{.season}{'additive' (default) or 'multiplicative'.}

\item{.prior_scale_changepoints}{Parameter modulating the flexibility of the
automatic changepoint selection. Large values will allow many changepoints,
small values will allow few changepoints.}

\item{.prior_scale_seasonality}{Parameter modulating the strength of the
seasonality model. Larger values allow the model to fit larger seasonal
fluctuations, smaller values dampen the seasonality.}

\item{.prior_scale_holidays}{Parameter modulating the strength of the holiday
components model, unless overridden in the holidays input.}

\item{.logistic_cap}{When growth is logistic, the upper-bound for "saturation".}

\item{.logistic_floor}{When growth is logistic, the lower-bound for "saturation"}

\item{.trees}{An integer for the number of trees contained in the ensemble.}

\item{.min_n}{An integer for the minimum number of data points in a node
that is required for the node to be split further.}

\item{.tree_depth}{An integer for the maximum depth of the tree
(i.e. number of splits) (specific engines only).}

\item{.learn_rate}{A number for the rate at which the boosting algorithm
adapts from iteration-to-iteration (specific engines only).}

\item{.loss_reduction}{A number for the reduction in the loss function
required to split further (specific engines only).}

\item{.stop_iter}{The number of iterations without improvement before
stopping (xgboost only).}
}
\value{
Returns a workflowsets object.
}
\description{
This function is used to quickly create a workflowsets object.
}
\details{
This function expects to take in the recipes that you want to use in
the modeling process. This is an automated workflow process. There are sensible
defaults set for the \code{prophet} and \code{prophet_xgboost} model specification,
but if you choose you can set them yourself if you have a good understanding
of what they should be.
}
\examples{
suppressPackageStartupMessages(library(modeltime))
suppressPackageStartupMessages(library(timetk))
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(rsample))

data <- AirPassengers \%>\%
  ts_to_tbl() \%>\%
  select(-index)

splits <- time_series_split(
   data
  , date_col
  , assess = 12
  , skip = 3
  , cumulative = TRUE
)

rec_objs <- ts_auto_recipe(
 .data = training(splits)
 , .date_col = date_col
 , .pred_col = value
)

wf_sets <- ts_wfs_prophet_reg("all_engines", rec_objs)
wf_sets

}
\seealso{
\url{https://workflowsets.tidymodels.org/}(workflowsets)

\url{https://business-science.github.io/modeltime/reference/prophet_reg.html}

\url{https://business-science.github.io/modeltime/reference/prophet_boost.html}

Other Auto Workflowsets: 
\code{\link{ts_wfs_arima_boost}()},
\code{\link{ts_wfs_auto_arima}()},
\code{\link{ts_wfs_ets_reg}()},
\code{\link{ts_wfs_lin_reg}()},
\code{\link{ts_wfs_mars}()},
\code{\link{ts_wfs_nnetar_reg}()},
\code{\link{ts_wfs_svm_poly}()},
\code{\link{ts_wfs_svm_rbf}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Auto Workflowsets}
