% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans-funcs.R
\name{kmeans_user_item_tbl}
\alias{kmeans_user_item_tbl}
\title{K-Means Functions}
\usage{
kmeans_user_item_tbl(.data, .row_input, .col_input)
}
\arguments{
\item{.data}{The data that you want to transform}

\item{.row_input}{The column that is going to be the row (user)}

\item{.col_input}{The column that is going to be the column (item)}
}
\value{
A aggregated/normalized user item tibble
}
\description{
Takes in a data.frame/tibble and transforms it into an aggregated/normalized
user-item tibble of proportions. The user will need to input the parameters
for the rows/user and the columns/items.
}
\details{
This function should be used before using a k-mean model. This is
commonly referred to as a user item matrix because "users" tend to be on the
rows and "items" (e.g. orders) on the columns.
}
\examples{
library(healthyR.data)
library(dplyr)

data_tbl <- healthyR_data\%>\%
   filter(ip_op_flag == "I") \%>\%
   filter(payer_grouping != "Medicare B") \%>\%
   filter(payer_grouping != "?") \%>\%
   select(service_line, payer_grouping) \%>\%
   mutate(record = 1) \%>\%
   as_tibble()

 kmeans_user_item_tbl(data_tbl, service_line, payer_grouping)

}
\author{
Steven P. Sanderson II, MPH
}
