% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_interp.R
\name{na_interp}
\alias{na_interp}
\title{Pad NA gaps of user-defined width with interpolated values.}
\usage{
na_interp(doy = doy, x = ts_x, y = ts_y, maxPadLength = 3)
}
\arguments{
\item{doy}{Date-of-year as per \code{make_whole} or \code{make_whole_fast}.}

\item{x}{Date as per \code{make_whole} or \code{make_whole_fast}.}

\item{y}{Measurement variable as per \code{make_whole} or \code{make_whole_fast}.}

\item{maxPadLength}{Specifies the maximum length of days over which to
interpolate (pad) missing data (specified as \code{NA}) in the input
temperature time series; i.e., any consecutive blocks of NAs with length
greater than \code{maxPadLength} will be left as \code{NA}. Set as an
integer. The default is \code{3} days.}
}
\value{
The function returns the data (a data.table) in a long format.
}
\description{
An internal function that helps to create a time series that will
then be used by \code{\link{clim_calc}} within \code{\link{ts2clm}}
to produce a climatology as desired by the user.
}
\author{
Smit, A. J.
}
