% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proto_event.R
\name{proto_event}
\alias{proto_event}
\title{Detect proto-events based on a chosen criterion (column).}
\usage{
proto_event(t_series, criterion_column, minDuration, joinAcrossGaps, maxGap)
}
\arguments{
\item{t_series}{A dataframe of the correct dimensions inherited
from \code{\link{detect_event}} within which this runs.}

\item{criterion_column}{The column to use for the detection of events.}

\item{minDuration}{Minimum duration for acceptance of detected events.}

\item{joinAcrossGaps}{This logic gate tells this internal function if
it should connect events across the \code{maxGap} (see below). The
default it inherits is \code{TRUE}.}

\item{maxGap}{This is the number of rows (days) across which distinct
events will be combined into one event if \code{joinAcrossGaps = TRUE}.}
}
\value{
A dataframe that will be used within
\code{\link{detect_event}}.
}
\description{
An internal function that detects proto-events, which are periods of
time above a threshold, but without necessarily considering a minimum
duration or joining across gaps.
}
\author{
Albertus J. Smit, Robert W. Schlegel
}
