% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heddle.R
\name{heddle}
\alias{heddle}
\title{Transform pattern objects into template pieces}
\usage{
heddle(data, pattern, ..., strip.whitespace = FALSE)
}
\arguments{
\item{data}{Input dataframe to pull replacement values from. Accepts either
vector or dataframe inputs.}

\item{pattern}{The base pattern, as either an atomic vector (which will be
recycled for every value in your data) or a vector of the same length as
your data (which will be applied element-wise to your data, so that
\code{data[[1]]} will replace \code{pattern[[1]]}).}

\item{...}{If \code{data} is a vector, a string representing the string to
replace with data values in each pattern. If \code{data} is a dataframe, a
set of name = variable pairs, with the name matching the keyword to be
replaced by that variable. Names should be quoted, variable names should
not.}

\item{strip.whitespace}{A boolean (TRUE/FALSE) value indicating if
whitespace should be removed from the replacement variable. Toggle this
on if you're using the variable in chunk labels or similar places.}
}
\value{
Returns a character vector of the pattern with placeholders
replaced by variables.
}
\description{
This function replicates pattern objects, replacing placeholder keywords in
each iteration with values from the provided data. This allows efficiently
creating R Markdown documents with many repeating pieces which may shift
alongside the underlying data.
}
\examples{
# When passed a vector, heddle replaces all placeholders passed to ...
# with each value
spList <- unique(iris$Species)
heddle(spList, "SPECIES CODE GWAR ", "GWAR")
heddle(spList, "SPECIES CODE GWAR ", "GWAR", "CODE")
heddle("test string", "pattern tk", "tk", strip.whitespace = TRUE)

# When passed a dataframe, heddle uses "Name" = Variable syntax to determine
# which values should replace which placeholders
spList <- data.frame(Species = c(unique(iris$Species), "test string"))
heddle(spList, "SPECIES CODE GWAR ", "GWAR" = Species)
heddle(spList, "SPECIES CODE GWAR ", "GWAR" = Species, "CODE" = Species)
}
\seealso{
Other manipulation functions: 
\code{\link{create_yaml_header}()},
\code{\link{make_template}()},
\code{\link{use_parameters}()}
}
\concept{manipulation functions}
