% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{eval_model}
\alias{eval_model}
\title{Evaluate Markov Model}
\usage{
eval_model(model, cycles, init, method)
}
\arguments{
\item{model}{An \code{uneval_model} object.}

\item{cycles}{positive integer. Number of Markov Cycles 
to compute.}

\item{init}{numeric vector, same length as number of 
model states. Number of individuals in each model state
at the beginning.}

\item{method}{Counting method.}
}
\value{
An \code{eval_model} object (actually a list of 
  evaluated parameters, matrix, states and cycles 
  counts).
}
\description{
Given an unevaluated Markov Model, an initial number of 
individual and a number of cycle to compute, returns the 
evaluated version of the objects and the count of 
individual per state per model cycle.
}
\details{
\code{init} need not be integer. E.g. specifying a vector
of type c(Q = 1, B = 0, C = 0, ...) returns the 
probabilities for an individual starting in state A to be
in each state, per cycle.
}
\examples{

\dontrun{
param <- define_parameters(
  a = markov_cycle + 1 * 2
)

mat <- define_matrix(
  1-1/a, 1/a,
  .1,    .9
)

sta <- define_state_list(
  A = define_state(cost = 10),
  B = define_state(cost = 2)
)

mod <- define_model(
  parameters = param,
  transition_matrix = mat,
  states = sta
)

eval_model(
  mod,
  init = c(10, 5),
  cycles = 5
)
}

}

