% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.R
\name{distributions}
\alias{distributions}
\alias{normal}
\alias{lognormal}
\alias{gamma}
\alias{binomial}
\alias{multinomial}
\alias{logitnormal}
\alias{beta}
\alias{triangle}
\alias{poisson}
\alias{define_distribution}
\alias{beta}
\alias{triangle}
\alias{use_distribution}
\title{Probability Density Functions for Probabilistic
Uncertainty Analysis}
\usage{
normal(mean, sd)

lognormal(mean, sd, meanlog, sdlog)

gamma(mean, sd)

binomial(prob, size)

multinomial(...)

logitnormal(mu, sigma)

beta(shape1, shape2)

triangle(lower, upper, peak = (lower + upper)/2)

poisson(mean)

define_distribution(x)

beta(shape1, shape2)

triangle(lower, upper, peak = (lower + upper)/2)

use_distribution(distribution, smooth = TRUE)
}
\arguments{
\item{mean}{Distribution mean.}

\item{sd}{Distribution standard deviation.}

\item{meanlog}{Mean on the log scale.}

\item{sdlog}{SD on the log scale.}

\item{prob}{Proportion.}

\item{size}{Size of sample used to estimate
proportion.}

\item{...}{Dirichlet distribution parameters.}

\item{mu}{Mean on the logit scale.}

\item{sigma}{SD on the logit scale.}

\item{shape1}{for beta distribution}

\item{shape2}{for beta distribution}

\item{lower}{lower bound of triangular
distribution.}

\item{upper}{upper bound of triangular
distribution.}

\item{peak}{peak of triangular distribution.}

\item{x}{A distribution function, see details.}

\item{distribution}{A numeric vector of
observations defining a distribution, usually
the output from an MCMC fit.}

\item{smooth}{Use gaussian kernel smoothing?}
}
\description{
Define a distribution for PSA parameters.
}
\details{
These functions are not exported, but only used
in \code{\link[=define_psa]{define_psa()}}. To specify a user-made
function use \code{\link[=define_distribution]{define_distribution()}}.

\code{\link[=use_distribution]{use_distribution()}} uses gaussian kernel
smoothing with a bandwith parameter calculated
by \code{\link[stats:density]{stats::density()}}. Values for unobserved
quantiles are calculated by linear
interpolation.

\code{\link[=define_distribution]{define_distribution()}} takes as argument a
function with a single argument, \code{x},
corresponding to a vector of quantiles. It
returns the distribution values for the given
quantiles. See examples.
}
\examples{
define_distribution(
  function(x) stats::qexp(p = x, rate = 0.5)
)

# a mixture of 2 gaussians
x <- c(rnorm(100), rnorm(100, 6))
plot(density(x))

use_distribution(x)
}
