% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_operations.R
\name{join}
\alias{join}
\alias{join_}
\title{Project Beyond a Survival Distribution with Another}
\usage{
join(..., at)

join_(dots, at)
}
\arguments{
\item{...}{Survival distributions to be used in the
projection.}

\item{at}{A vector of times corresponding to the cut
point(s) to be used.}

\item{dots}{Used to work around non-standard evaluation.}
}
\value{
A \code{surv_projection} object.
}
\description{
Project survival from a survival distribution using one
or more survival distributions using the specified cut points.
}
\examples{

dist1 <- define_surv_dist(distribution = "exp", rate = .5)
dist2 <- define_surv_dist(distribution = "gompertz", rate = .5, shape = 1)
join_dist <- join(dist1, dist2, at=20)
}
