% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{texts}
\alias{texts}
\title{Extract texts or structured data from a batch result}
\usage{
texts(x, ...)
}
\arguments{
\item{x}{A batch object}

\item{...}{Additional arguments passed to methods}
}
\value{
A character vector or list of text responses. If a type specification was provided to the batch, structured data objects will be returned instead.
}
\description{
Extract texts or structured data from a batch result
}
\examples{
\dontshow{if (ellmer::has_credentials("openai")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create a chat processor
chat <- chat_sequential(chat_openai())

# Process a batch of prompts
batch <- chat$batch(list(
  "What is R?",
  "Explain base R versus tidyverse",
  "Explain vectors, lists, and data frames"
))

# Extract text responses
batch$texts()
\dontshow{\}) # examplesIf}
}
