% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findParasite.R
\name{findParasite}
\alias{findParasite}
\title{Find host-parasite interactions for a given parasite species.}
\usage{
findParasite(genus = NULL, species = NULL, group = NULL,
  subgroup = NULL, location = NULL, citation = FALSE,
  hostState = NULL, speciesOnly = FALSE, validateHosts = FALSE,
  removeDuplicates = FALSE)
}
\arguments{
\item{genus}{Parasite genus}

\item{species}{Parasite species}

\item{group}{Parasite group - Cestodes, Acanthocephalans, Monogeneans, 
Nematodes, Trematodes, or Turbellarian etc. (Turb)}

\item{subgroup}{Parasite subgroup (family names largely)}

\item{location}{Location of host-parasite interaction.}

\item{citation}{Boolean. Should the output include the citation link and 
the number of supporting citations? default is FALSE}

\item{hostState}{number corresponding to one of six different host states. 
The default value is NULL
     includes all host states}

\item{speciesOnly}{boolean flag to remove host and parasite species
where data are only available at genus level (default = FALSE)}

\item{validateHosts}{boolean flag to check host species names
against Catalogue of Life information and output taxonomic
information (default = FALSE)}

\item{removeDuplicates}{(boolean) should duplicate host-parasite 
combinations be removed? (default is FALSE)}
}
\value{
Three (or five) column data.frame containing host species, 
  parasite species (shortened name and full name), and citation link and 
  number of citations (if \code{citation = TRUE}), with each row corresponding 
  to an occurrence of a parasite species on a host species.
}
\description{
Given a host genus and/or species, this function returns a matrix containing
host-parasite interaction data. Search available locations using 
\code{data(locations)}.
}
\details{
\code{hostState} can take values 1-6 corresponding to if the recorded host 
was found 
\itemize{ 
	\item (1) "In the wild"
	\item (2) "Zoo captivity" 
	\item (3) "Domesticated"
	\item (4) "Experimental"
	\item (5) "Commercial source"
	\item (6) "Accidental infestation"
 }
}
\examples{

\donttest{strongHosts <- helminthR::findParasite(genus = "Strongyloides")}

# An example of how to query multiple parasite species when 
# you have a vector of parasite species names

parasites <- c("Ascaris aculeati", "Oxyuris flagellum")
\donttest{
 plyr::ldply(parasites, 
   function(x){
     helminthR::findParasite(unlist(strsplit(x, " "))[1], 
       unlist(strsplit(x," "))[2])
   }
 )
}
}
\references{
Gibson, D. I., Bray, R. A., & Harris, E. A. (Compilers) (2005).
Host-Parasite Database of the Natural History Museum, London. 
<http://www.nhm.ac.uk/research-curation/scientific-resources/taxonomy-systematics/host-parasites/>
}
\seealso{
\code{\link{findHost}}
}
\author{
Tad Dallas
}
