% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoline.R
\name{isoline}
\alias{isoline}
\title{HERE Isoline Routing API: Calculate Isoline}
\usage{
isoline(
  poi,
  datetime = Sys.time(),
  arrival = FALSE,
  range = seq(5, 30, 5) * 60,
  range_type = "time",
  routing_mode = "fast",
  transport_mode = "car",
  traffic = TRUE,
  optimize = "balanced",
  consumption_model = NULL,
  aggregate = TRUE,
  url_only = FALSE
)
}
\arguments{
\item{poi}{\code{sf} object, Points of Interest (POIs) of geometry type \code{POINT}.}

\item{datetime}{\code{POSIXct} object, datetime for the departure (or arrival if \code{arrival = TRUE}).}

\item{arrival}{boolean, are the provided Points of Interest (POIs) the origin or destination locations (\code{default = FALSE})?}

\item{range}{numeric, a vector of type \code{integer} containing the breaks for the generation of the isolines: (1) time in seconds; (2) distance in meters; (3) consumption in Wh.}

\item{range_type}{character, unit of the isolines: \code{"distance"}, \code{"time"} or \code{"consumption"}.}

\item{routing_mode}{character, set the routing mode: \code{"fast"} or \code{"short"}.}

\item{transport_mode}{character, set the transport mode: \code{"car"}, \code{"pedestrian"} or \code{"truck"}.}

\item{traffic}{boolean, use real-time traffic or prediction in routing (\code{default = TRUE})? If no traffic is selected, the \code{datetime} is set to \code{"any"} and the request is processed independently from time.}

\item{optimize, }{character, specifies how isoline calculation is optimized: \code{"balanced"}, \code{"quality"} or \code{"performance"} (\code{default = "balanced"}).}

\item{consumption_model}{character, specify the consumption model of the vehicle, see \href{https://developer.here.com/documentation/routing-api/8.16.0/dev_guide/topics/use-cases/consumption-model.html}{consumption model} for more information (\code{default = NULL} a average electric car is set).}

\item{aggregate}{boolean, aggregate (with function \code{min}) and intersect the isolines from geometry type \code{POLYGON} to geometry type \code{MULTIPOLYGON} (\code{default = TRUE})?}

\item{url_only}{boolean, only return the generated URLs (\code{default = FALSE})?}
}
\value{
An \code{sf} object containing the requested isolines.
}
\description{
Calcuates isolines (\code{POLYGON} or \code{MULTIPOLYGON}) using the HERE 'Isoline Routing' API
that connect the end points of all routes leaving from defined centers (POIs) with either
a specified length, a specified travel time or consumption (only the default E-car available).
}
\examples{
# Provide an API Key for a HERE project
set_key("<YOUR API KEY>")

# Isochrone for 5, 10, 15, 20, 25 and 30 minutes driving time
isolines <- isoline(
  poi = poi,
  range = seq(5, 30, 5) * 60,
  url_only = TRUE
)
}
\references{
\href{https://developer.here.com/documentation/isoline-routing-api/8.4.0/dev_guide/index.html}{HERE Isoline Routing API}
}
