#include "h_ergm_latent.h"

latentstructure* Initialize_Latentstructure(int number, int n, int threshold, int d)
/*
input: maximum number of categories, number of nodes, minimum number of nodes so that structural parameters show up in ergm pmf, number of structural parameters
ouput: latent structure
*/
{
  latentstructure *ls;
  ls = (latentstructure*) S_alloc(1,sizeof(latentstructure));
  /* Basics: */
  ls->number = number; /* (Maximum) number of categories */
  ls->n = n; /* Number of nodes */
  /* Law generating structure: */
  ls->p = D(number); /* Category-bound probability */
  /* Structure: */
  ls->size = I(number); /* Category-bound variable: number of nodes belonging to category */
  ls->indicator = I(n); /* Node-bound variable: category to which node belongs */
  /* Law generating data: */
  ls->threshold = threshold; /* Minimum number of nodes so that structural parameters show up in ergm pmf */
  ls->d = d;
  ls->theta = DD(d,number+1); /* Category-bound parameters */
  return ls;
}

ergmstructure* Initialize_Ergm(int terms, int *hierarchical, int d, int d1, int d2, int *structural)
/* 
input: number of ergm terms, indicator of hierarchical model terms, number of parameters, number of non-structural, structural parameters, indicator of structural parameters
output: ergm structure
*/
{
  ergmstructure *ergm;
  ergm = (ergmstructure*) S_alloc(1,sizeof(ergmstructure));
  ergm->terms = terms; /* Number of ergm terms */
  ergm->hierarchical = I(terms); /* Indicator of hierarchical ergm terms */
  Set_I_I(terms,ergm->hierarchical,hierarchical);
  ergm->d = d; /* Number of parameters */
  ergm->d1 = d1; /* Number of non-structural parameters */
  ergm->d2 = d2; /* Number of structural parameters */
  ergm->structural = I(d); /* Indicator of structural parameters */
  Set_I_I(d,ergm->structural,structural);
  ergm->theta = D(d1); /* Non-structural parameters */
  return ergm;
}

double Expected_K_CRP(latentstructure *ls)
/*
input: number of nodes, clustering parameter of Chinese restaurant process
output: prior expectation of number of non-empty blocks generated by Chinese restaurant process
*/
{
  int i;
  double sum;
  sum = 0.0;
  if (ls->alpha > 0.0)
    {
    for (i = 1; i < ls->n + 1; i++) 
      {
      sum = sum + (ls->alpha / (i - 1.0 + ls->alpha));
      }
    }
  return sum;
}

