\name{simulate}

\alias{simulate}

\alias{simulate.hergm}

\alias{hergm.simulate}

\title{Simulation}

\description{

The function \code{simulate.hergm} simulates a network.

}

\usage{

\method{simulate}{hergm}(model = NULL,
                         network = NULL,
                         eta = NULL,
                         max_number = NULL,
                         indicator = NULL,
                         sample_size = 1000,
                         sample = NULL,
                         verbose = 1,
                         \dots)
}

\arguments{

\item{model}{model.}

\item{network}{network object; networks can be created by calling the function \code{network}.}

\item{eta}{parameters.}

\item{max_number}{maximum number of blocks.}

\item{indicator}{vector of block memberships of nodes.}

\item{sample_size}{number of networks to be simulated.}

\item{sample}{the argument \code{sample} is a list of arguments generated by the function \code{hergm}; do not use \code{sample} unless the function \code{hergm} was used to estimate the model and you want to conduct goodness-of-fit assessments. An alternative are goodness-of-fit tests by the function \code{hergm.gof}.}

\item{verbose}{if \code{verbose == -1}, no console output; if \code{verbose == 0}, short console output; if \code{verbose == +1}, long console output.}

\item{\dots}{additional arguments, to be passed to lower-level functions in the future.}

}

\value{

\code{edgelists}{list of edgelists of generated networks.}

}

\seealso{network, hergm}

\examples{
\dontrun{
data(example)

sample <- simulate.hergm(d ~ edges_ij + triangle_ijk)
}
}

