% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_deltal.R
\name{compute_deltal}
\alias{compute_deltal}
\title{Compute \eqn{\Delta}l}
\usage{
compute_deltal(typed.genos, M_values, ncores = 1)
}
\arguments{
\item{typed.genos}{A named list, usually generated by
\code{\link{calc_geno_probs}}.
Each element of the list is a data frame specifying all possible joint
genotypes of selected family members within each family, and the joint
probability of each genotype combination.}

\item{M_values}{A matrix of M-values,with rows corresponding to the
methylation sites and columns corresponding to people.
The column names should correspond to the column names appearing in
\code{typed.genos}.}

\item{ncores}{The number of cores to be used, with \code{ncores = 1} (the default)
corresponding to non-parallel computing.
When \code{ncores > 1}, the \code{parallel} package is used to
parallelize the calculation, by dividing the methylation sites between
the cores.}
}
\value{
A data frame with 15 columns. In the column names, the suffixes
\code{.mendel} and \code{.mix} refer the Mendelian and mixture models of
(Joo et al., 2018).
Briefly, the mixture model is the standard Gaussian mixture model with two
groups (group \code{0} and group \code{1}),
so group memberships are independent and the M-values of each group are
normally distributed. The Mendelian model is the same except that group
memberships are dependent within families, and are modelled as the carrier
status of a rare, autosomal genetic variant.
In the column names, the prefixes \code{mu} and \code{sd} refer to the maximum
likelihood estimates of the mean and standard deviation of each group's
normal distribution, and the suffix \code{ll} refers to each model's maximised
log-likelihood (i.e., the log-likelihood function evaluated at the maximum
likelihood estimates).  The suffix \code{.null} refers to the null model that is
nested inside both the Mendelian and mixture models, in which the means and
standard deviations for the two groups are equal
(i.e., \code{mu0 = mu1} and \code{sd0 = sd1}).
The column \code{delta.l} gives the difference between \code{ll.mendel} and \code{ll.mix},
and is the measure of heritability (Delta l) that was introduced in
(Joo et al., 2018).
}
\description{
For each methylation site, compute a measure of heritability called Delta l
(with larger values corresponding to more highly heritable methylation
sites), which is described briefly below and fully in (Joo et al., 2018).
}
\examples{
# Example data
str(ped)
str(M_values)

# Calculate genotype probabilities
typed.genos <- calc_geno_probs(ped)
str(typed.genos)

\donttest{
# Compute Delta l
deltal <- compute_deltal(typed.genos, M_values, ncores = 4)
str(deltal)
}

}
\references{
Joo JE, Dowty JG, Milne RL, Wong EM, Dugué PA, English D, Hopper JL,
Goldgar DE, Giles GG, Southey MC, kConFab.  Heritable DNA methylation marks
associated with susceptibility to breast cancer.  Nat Commun. 2018
Feb 28;9(1):867. \url{https://doi.org/10.1038/s41467-018-03058-6}
}
