% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator.R
\name{update_batch}
\alias{update_batch}
\title{Updates the Hermite series based estimator with a batch of data}
\usage{
update_batch(this, x)
}
\arguments{
\item{this}{A hermite_estimator_univar or hermite_estimator_bivar object.}

\item{x}{A numeric vector or a numeric matrix. Note that for univariate 
estimators, x is a numeric vector of observations to be incorporated. For 
bivariate estimators, x is a numeric matrix with n rows for n observations 
and 2 columns.}
}
\value{
An object of class hermite_estimator_univar or 
hermite_estimator_bivar.
}
\description{
This method can be applied in one-pass batch estimation settings. This
method cannot be used with an exponentially weighted estimator.
}
\examples{
hermite_est <- hermite_estimator(N = 10, standardize = TRUE, 
est_type="univariate")
hermite_est <- update_batch(hermite_est, x = c(1, 2))
hermite_est <- hermite_estimator(N = 10, standardize = TRUE, 
est_type="bivariate")
hermite_est <- update_batch(hermite_est, x = matrix(c(1,1,2,2,3,3), 
nrow=3, ncol=2,byrow=TRUE))
}
