#' @name wrfg_cgcm3_tasmax
#' @aliases wrfg_lon wrfg_lat
#' @title Computer-generated temperature data
#' @description The maximum daily surface air temperature
#'   (C) of land locations for the time period
#'   January 1, 2041 through January
#'   30, 1941 for the WRFG-CGCM3 computer generated data made
#'   available through the North American Regional Climate
#'   Change Assessment Program (NARCCAP).  The non-land
#'   locations are specified as NA.
#' @docType data
#' @usage data(wrfg_cgcm3_tasmax)
#' @references Mearns, L.O., et al., 2007, updated 2014. The
#' North American Regional Climate Change Assessment Program
#' dataset, National Center for Atmospheric Research Earth
#' System Grid data portal, Boulder, CO. Data downloaded
#' 2018-06-13. <doi:10.5065/D6RN35ST>.
#'
#' Mearns, L. O., W. J. Gutowski, R. Jones, L.-Y. Leung, S.
#' McGinnis, A. M. B. Nunes, and Y. Qian. "A regional
#' climate change assessment program for North America."
#' EOS, Vol. 90, No. 36, 8 September 2009, pp. 311-312.
#' <doi:10.1029/2009EO360002>.
#' @format Matrices \code{wrfg_lon} and \code{wrfg_lat} and array
#'   \code{wrfg_cgcm3_tasmax}.
NULL
